# 1.0 Account and Authorization


## 1.1 Azure Active Directory




### 1.1.1 (L1) Ensure multifactor authentication is enabled for all users in administrative roles (Automated)

#### Profile Applicability:
- E3 Level 1


#### Description:

Enable multifactor authentication for all users who are members of administrative roles in
the Microsoft 365 tenant. These include roles such as:

- Global Administrator
- Billing Administrator
- Exchange Administrator
- SharePoint Administrator
- Password Administrator
- Skype for Business Administrator
- Service Support Administrator
- User Administrator
- Dynamics 365 Service Administrator
- Power BI Administrator


#### Rationale:

Multifactor authentication requires an individual to present a minimum of two separate
forms of authentication before access is granted. Multifactor authentication provides
additional assurance that the individual attempting to gain access is who they claim to be.
With multifactor authentication, an attacker would need to compromise at least two
different authentication mechanisms, increasing the difficulty of compromise and thus
reducing the risk.

#### Impact:

Implementation of multifactor authentication for all users in administrative roles will
necessitate a change to user routine. All users in administrative roles will be required to
enroll in multifactor authentication using using phone, SMS, or an authentication
application. After enrollment, use of multifactor authentication will be required for future
access to the environment



#### Audit






## 1.1.2 (L2) Ensure multifactor authentication is enabled for all users in all roles (Manual)









